function [R,Br] = Iter(E)

% Funkcija izracunava priblizno resenje jednacine f(x)=4.*exp(x)-5.*(x+1)
% metodom proste iteracije

% Pomocnu funkciju koja zadovoljava da je x=Fi(x) i koja je kontrakcija na
% intervalu (-1,0) nije i kontrakcija na intervalu (0.5,1), stoga cemo je naci 
% nesto drugacijim postupkom, logaritmovanjem jednacine 4.*exp(x)=5.*(x+1) 
% dobijamo x=ln((1.25).*(x+1))=Fi(x), ili x=ln(1.25) + ln(x+1)

Fi='ln((1.25).*(x+1))';

% Prvi izvod f-je Fi je Fi'(x)=1./(x+1)
% Apsolutna vrednost izvoda f-je Fi(x) je abs(ln((1.25).*(x+1))), pa s obzirom
% da je |Fi'(0.5)|=0.6666, a |Fi'(1)|=0.5000 znaci i da je cela funkcija
% |Fi'(x)|<=0.6666 (<1), pa cemo za q uzeti:
q=0.6666;

% Kriterijum zazustavljanja je:
kz=(1-q).*E./q;

% Za pocetnu vrednost cemo uzeti polovinu intervala (0.5,1), tj.
y(1)=0.7500;
x=y(1);
% Druga vrednost koja se dobija kao Fi(y(1))
y(2)=eval(Fi); 
i=2;

% a zatim pravimo iterativni niz sve dok je razlika poslednja dva clana
% niza veca od kriterijuma zaustavljanja
while abs(y(i)-y(i-1))>kz
      x=y(i);
      i=i+1;
      y(i)=eval(Fi);
end

% Poslednji dobijeni clan iterativnog niza je priblizno resenje nase
% jednacine
R=y(i);

% Br je broj iteracija koji je bio potreban za dobijanje resenja
Br=i;